#include "ScnGenres.h"
#include "scngames.h"

#include <vector>
#include <map>

using namespace std;

//ContentItem * ListItems;
GenreItems * g_items;

HRESULT CScnGenres::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	GenreDisp = L"";

  	//char temp[1024];
    // Retrieve controls for later use.
    GetChildById( L"GenreList", &m_list );
    GetChildById( L"GamesList", &m_gameslist );
    GetChildById( L"TitleText", &m_title );
    /*GetChildById( L"Genre", &m_genre );
    GetChildById( L"Cover", &m_cover );
    GetChildById( L"ScreenShot1", &m_ss1 );
    GetChildById( L"ScreenShot2", &m_ss2 );
    GetChildById( L"DescText", &m_desc );*/
   // GetChildById( L"TxtFreeMem", &m_freemem );
	GetChildById( L"GameInGenre", &m_gamesingenre );
	GetChildById( L"GameDetails", &m_xbutton );
	GetChildById( L"AButton", &m_abutton );
	GetChildById( L"BackButton", &m_bbutton );
    GetChildById( L"Date", &m_date );
    GetChildById( L"Time", &m_time );
    GetChildById( L"DateTime", &m_datetime );
	

	//m_freemem.SetText(L"TESTING");

	if (ToDisplay == 0)
		m_title.SetText(L"XBox Live Arcade Games - Genres");
	if (ToDisplay == 1)
		m_title.SetText(L"XBox 360 Games - Genres");
	if (ToDisplay == 2)
		m_title.SetText(L"XBox Games - Genres");

	XUIMessage xuiMsg;
    XuiMessage(&xuiMsg,XM_LIST_REFRESH);
	XuiSendMessage( m_gameslist, &xuiMsg );

	//m_xbutton.SetShow(FALSE);
	ListSel(0);

	SetClock(m_date,m_time,m_datetime);
	SetTimer(TM_CLOCK,1000);

	return S_OK;
}


//----------------------------------------------------------------------------------
// Handler for the button press message.
//----------------------------------------------------------------------------------
HRESULT CScnGenres::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	GenreDisp = L"";

    if ( hObjPressed == m_list )
    {
		int nIndex = m_list.GetCurSel();

		GenreItem * item = g_items->pItems[nIndex];

 		//Mount(DEVICE_USB0,"usb0:");
		string image = wstrtostr(item->title);
		DebugMsg("Viewing Genre ");
		DebugMsg(image.c_str());
		//XLaunchNewImage(image.c_str(), NULL);

		GenreDisp = item->title;
       
		HXUIOBJ hScene = NULL;
		HRESULT hResult = CXuiScene::SceneCreate( L"xbox360.xur", &hScene );
		DebugMsg("CXuiScene::SceneCreate : %x (%x)",hResult,hScene);
		hResult = CXuiScene::NavigateForward( hScene );
		DebugMsg("CXuiScene::NavigateForward : %x",hResult);

		bHandled = TRUE;
		return S_OK;
    } else if ( hObjPressed == m_bbutton)
	{
		GenreDisp = L"";

		DebugMsg("Genre Back - %s",wstrtostr(GenreDisp).c_str());

		XUIMessage xuiMsg;
		XuiMessage(&xuiMsg,XM_LIST_REFRESH);
		XuiSendMessage( m_gameslist, &xuiMsg );
	} else if ( hObjPressed == m_gameslist )
	{
        int nIndex = m_gameslist.GetCurSel();

		ContentItem * item = items->pItems[nIndex];
		cl.LaunchGame(item);
	}

    return S_OK;
}

#define MB	(1024*1024)
#define AddStr(a,b) (pstrOut += sprintf_s( pstrOut,sizeof(pstrOut), a, b ))

HRESULT CScnGenres::OnNotifySelChanged( HXUIOBJ hObjSource, XUINotifySelChanged* pNotifySelChangedData, BOOL& bHandled )
{
    MEMORYSTATUS stat;
    //CHAR strOut[1024], *pstrOut;

    // Get the memory status.
    GlobalMemoryStatus( &stat );

    // Setup the output string.
   /* pstrOut = strOut;
    AddStr( "%4u free MB\n", stat.dwAvailPhys / MB );

	wstring temp = strtowstr(strOut);

	m_freemem.SetText(temp.c_str());*/

	if( hObjSource == m_list )
    {
        int curSel = m_list.GetCurSel();

		ListSel(curSel);

        bHandled = TRUE;
    } else if ( hObjSource == m_gameslist )
	{
        int curSel = m_gameslist.GetCurSel();
		ContentItem * item = items->pItems[curSel];
		CurentGame = item;
	}

    return S_OK;
}

void CScnGenres::ListSel(int curSel)
{
	if (curSel >= g_items->nItems)
		return;

	GenreItem * item = g_items->pItems[curSel];



	wstring gamelist = cl.GetGameList(ToDisplay, item->title);

	m_gamesingenre.SetText(gamelist.c_str());

	GenreDisp = item->title;

	XUIMessage xuiMsg;
    XuiMessage(&xuiMsg,XM_LIST_REFRESH);
	XuiSendMessage( m_gameslist, &xuiMsg );

	if (items->nItems > 0)
	{
		CurentGame = items->pItems[0];
	}

	GenreDisp = L"";
}

HRESULT CGenreList::OnInit(XUIMessageInit *pInitData, BOOL& bHandled)
{
	g_items = cl.GetGenres(ToDisplay);
	InsertItems( 0, g_items->nItems );
	return S_OK;
}
    
// Gets called every frame
HRESULT CGenreList::OnGetSourceDataText(XUIMessageGetSourceText *pGetSourceTextData, BOOL& bHandled)
{
	if( ( 0 == pGetSourceTextData->iData ) && ( ( pGetSourceTextData->bItemData ) ) ) {
		pGetSourceTextData->szText = 
			g_items->pItems[pGetSourceTextData->iItem]->title.c_str();
		bHandled = TRUE;
	}
	return S_OK;
}
    
HRESULT CGenreList::OnGetItemCountAll(XUIMessageGetItemCount *pGetItemCountData, BOOL& bHandled)
{
	pGetItemCountData->cItems = g_items->nItems;
	bHandled = TRUE;
	return S_OK;
}

HRESULT CGenreList::OnGetSourceDataImage(XUIMessageGetSourceImage *pGetSourceImageData, BOOL& bHandled)
{
	if( ( 0 == pGetSourceImageData->iData ) && ( pGetSourceImageData->bItemData ) ) {
		if (g_items->pItems[pGetSourceImageData->iItem]->icon.size() > 0 )
		{
			pGetSourceImageData->szPath = 
				g_items->pItems[pGetSourceImageData->iItem]->icon.c_str();
		} else {
			pGetSourceImageData->szPath = L"noicon.png";

		}
		bHandled = TRUE;
	}
	if( ( 5 == pGetSourceImageData->iData ) && ( pGetSourceImageData->bItemData ) ) {
			pGetSourceImageData->szPath = L"ylwstar.png";
		bHandled = TRUE;
	}
	return S_OK;
}
HRESULT CScnGenres::OnNotifySetFocus( HXUIOBJ hObjSource, XUINotifyFocus *pNotifyFocusData, BOOL& bHandled )
{
    // hObjSource is the control that is getting the focus
    // pNotifyFocusData->hObjOther is the control that is losing focus
	if (hObjSource == m_gameslist)
	{
		m_xbutton.SetShow(TRUE);
		m_xbutton.SetEnable(TRUE);
		m_abutton.SetText(L"Play Game");
	} else if (hObjSource == m_list)
	{
		m_xbutton.SetShow(FALSE);
		m_xbutton.SetEnable(FALSE);
		m_abutton.SetText(L"View Genre");
	}
    
    bHandled = TRUE;
    return( S_OK );
}

HRESULT CScnGenres::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    switch( pTimer->nId )
    {
    case TM_CLOCK:
		SetClock(m_date,m_time,m_datetime);
		break;
	}
    bHandled = TRUE;
    return S_OK;
}
